(function () {
  if (!window.SCT || !SCT.elements) return;

  // SCT.elements => { "btnTeklifAl": "Teklif Al", "btnWhatsapp": "WhatsApp" }
  const ids = Object.keys(SCT.elements);
  if (!ids.length) return;

  const selector = ids.map((id) => "#" + CSS.escape(id)).join(",");

  document.addEventListener(
    "click",
    function (e) {
      const el = e.target.closest(selector);
      if (!el) return;

      const data = new URLSearchParams();
      data.append("action", "sct_click");
      data.append("nonce", SCT.nonce);
      data.append("element_id", el.id);
      data.append("page_url", location.href);
      data.append("referrer", document.referrer || "");

      // keepalive: page unload sırasında da gönderebilsin
      fetch(SCT.ajaxurl, {
        method: "POST",
        headers: { "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8" },
        body: data.toString(),
        keepalive: true
      }).catch(function () {});
    },
    { passive: true }
  );
})();