jQuery(function($){
  // Presets
  const $preset = $('#preset');
  function applyPreset(v){
    const map = {
      gmail:    {host:'smtp.gmail.com', port:'587', enc:'tls', autotls:'yes', auth:'yes'},
      outlook:  {host:'smtp.office365.com', port:'587', enc:'tls', autotls:'yes', auth:'yes'},
      yandex:   {host:'smtp.yandex.com', port:'465', enc:'ssl', autotls:'yes', auth:'yes'},
	  hositnger:   {host:'smtp.hostinger.com', port:'465', enc:'ssl', autotls:'yes', auth:'yes'},
      zoho:     {host:'smtp.zoho.com', port:'587', enc:'tls', autotls:'yes', auth:'yes'},
      sendgrid: {host:'smtp.sendgrid.net', port:'587', enc:'tls', autotls:'yes', auth:'yes'}
    };
    if (!map[v]) return; // Manuel ayarla
    $('#host').val(map[v].host);
    $('#port').val(map[v].port);
    $('#encryption').val(map[v].enc);
    $('input[name="sstmps_settings[autotls]"][value="'+map[v].autotls+'"]').prop('checked', true);
    $('input[name="sstmps_settings[auth]"][value="'+map[v].auth+'"]').prop('checked', true);
  }
  $preset.on('change', function(){ applyPreset($(this).val()); });

  // Connection test
  $('#sstmps-conn-test').on('click', function(e){
    e.preventDefault();
    const $res = $('#sstmps-conn-result').text('Test ediliyor...').css('color','inherit');
    $.post(sstmpsAdmin.ajaxurl, {
      action: 'sstmps_conn_test',
      nonce: sstmpsAdmin.nonce
    }).done(function(resp){
      if (resp && resp.success) {
        $res.text(resp.data.message || 'Bağlantı başarılı.').css('color','#0a0');
      } else {
        const msg = (resp && resp.data && (resp.data.message || resp.data)) ? (resp.data.message || resp.data) : 'Bağlantı başarısız.';
        $res.text(msg).css('color','#a00');
      }
    }).fail(function(){
      $res.text('İstek başarısız (AJAX).').css('color','#a00');
    });
  });
});