<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class SSTMPS_Updater {
    private $plugin_file;
    private $metadata_url;
    private $version;
    private $plugin_basename;

    public function __construct( $plugin_file, $metadata_url, $version ) {
        $this->plugin_file = $plugin_file;
        $this->metadata_url = $metadata_url;
        $this->version = $version;
        $this->plugin_basename = plugin_basename( $plugin_file );

        add_filter( 'pre_set_site_transient_update_plugins', array( $this, 'check_for_update' ) );
        add_filter( 'plugins_api', array( $this, 'plugins_api' ), 10, 3 );
        add_action( 'in_plugin_update_message-' . $this->plugin_basename, array( $this, 'update_message' ), 10, 2 );
    }

    private function get_metadata() {
        $response = wp_remote_get( $this->metadata_url, array( 'timeout' => 10 ) );
        if ( is_wp_error( $response ) ) return false;
        $code = wp_remote_retrieve_response_code( $response );
        if ( 200 !== $code ) return false;
        $body = wp_remote_retrieve_body( $response );
        $data = json_decode( $body );
        if ( ! $data ) return false;
        return $data;
    }

    public function check_for_update( $transient ) {
        if ( empty( $transient->checked ) ) return $transient;

        $meta = $this->get_metadata();
        if ( ! $meta || empty( $meta->version ) || empty( $meta->download_url ) ) return $transient;

        if ( version_compare( $this->version, $meta->version, '<' ) ) {
            $obj = new stdClass();
            $obj->slug = SSMTPS_SLUG;
            $obj->plugin = $this->plugin_basename;
            $obj->new_version = $meta->version;
            $obj->url = isset( $meta->homepage ) ? $meta->homepage : '';
            $obj->package = $meta->download_url;
            $obj->tested = isset( $meta->tested ) ? $meta->tested : '';
            $obj->requires = isset( $meta->requires ) ? $meta->requires : '';
            $transient->response[ $this->plugin_basename ] = $obj;
        }
        return $transient;
    }

    public function plugins_api( $false, $action, $args ) {
        if ( 'plugin_information' !== $action ) return $false;
        if ( empty( $args->slug ) || $args->slug !== SSMTPS_SLUG ) return $false;

        $meta = $this->get_metadata();
        if ( ! $meta ) return $false;

        $res = new stdClass();
        $res->name = 'Sistemsel SMTP Servis';
        $res->slug = SSMTPS_SLUG;
        $res->version = isset( $meta->version ) ? $meta->version : '';
        $res->author = '<a href="https://sistemsel.com">Sistemsel Medya</a>';
        $res->homepage = isset( $meta->homepage ) ? $meta->homepage : '';
        $res->download_link = isset( $meta->download_url ) ? $meta->download_url : '';
        $res->requires = isset( $meta->requires ) ? $meta->requires : '';
        $res->tested = isset( $meta->tested ) ? $meta->tested : '';
        $res->last_updated = isset( $meta->last_updated ) ? $meta->last_updated : '';
        $res->sections = array(
            'description' => isset( $meta->sections->description ) ? $meta->sections->description : 'SMTP eklentisi.',
            'changelog'   => isset( $meta->sections->changelog ) ? $meta->sections->changelog : '',
        );
        return $res;
    }

    public function update_message( $data, $response ) {
        echo ' Self-hosted güncelleme: ' . esc_html( $this->metadata_url );
    }
}
