<?php
if ( ! defined('ABSPATH') ) exit;

class SWPL_Updater {
    private $basename;
    private $metadata_url;
    private $version;

    public function __construct( $basename, $metadata_url, $version ) {
        $this->basename     = $basename;
        $this->metadata_url = $metadata_url;
        $this->version      = $version;

        add_filter('pre_set_site_transient_update_plugins', array($this,'check_updates'));
        add_filter('plugins_api', array($this,'plugins_api'), 10, 3);
    }

    private function fetch_metadata() {
        $resp = wp_remote_get( $this->metadata_url, array('timeout'=>8) );
        if ( is_wp_error($resp) ) return null;
        $code = wp_remote_retrieve_response_code($resp);
        if ( $code !== 200 ) return null;
        $body = wp_remote_retrieve_body($resp);
        $json = json_decode($body, true);
        return is_array($json) ? $json : null;
    }

    public function check_updates( $transient ) {
        if ( empty($transient->checked) ) return $transient;

        $meta = $this->fetch_metadata();
        if ( ! $meta ) return $transient;

        $new_version = isset($meta['version']) ? $meta['version'] : null;
        if ( $new_version && version_compare( $new_version, $this->version, '>' ) ) {
            $obj = (object) array(
                'slug'        => dirname($this->basename),
                'plugin'      => $this->basename,
                'new_version' => $new_version,
                'tested'      => isset($meta['tested']) ? $meta['tested'] : '',
                'requires'    => isset($meta['requires']) ? $meta['requires'] : '',
                'package'     => isset($meta['download_url']) ? $meta['download_url'] : '',
                'url'         => isset($meta['homepage']) ? $meta['homepage'] : '',
                'icons'       => isset($meta['icons']) ? $meta['icons'] : array(),
                'banners'     => isset($meta['banners']) ? $meta['banners'] : array(),
            );
            $transient->response[ $this->basename ] = $obj;
        }
        return $transient;
    }

    public function plugins_api( $result, $action, $args ) {
        if ( $action !== 'plugin_information' ) return $result;
        $expected = dirname($this->basename);
        $req_slug = !empty($args->slug) ? $args->slug : $expected;
        if ( $req_slug !== $expected ) return $result;

        $meta = $this->fetch_metadata();
        if ( ! $meta ) return $result;

        $info = (object) array(
            'name'          => isset($meta['name']) ? $meta['name'] : 'Sistemsel WP Login Gizleme',
            'slug'          => dirname($this->basename),
            'version'       => isset($meta['version']) ? $meta['version'] : '',
            'author'        => isset($meta['author']) ? $meta['author'] : 'Sistemsel Medya',
            'author_profile'=> isset($meta['author_profile']) ? $meta['author_profile'] : 'https://sistemsel.com',
            'homepage'      => isset($meta['homepage']) ? $meta['homepage'] : '',
            'sections'      => array(
                'description' => isset($meta['sections']['description']) ? $meta['sections']['description'] : 'Giriş URL’sini değiştirir.',
                'changelog'   => isset($meta['sections']['changelog']) ? $meta['sections']['changelog'] : '',
            ),
            'download_link' => isset($meta['download_url']) ? $meta['download_url'] : '',
            'requires'      => isset($meta['requires']) ? $meta['requires'] : '',
            'tested'        => isset($meta['tested']) ? $meta['tested'] : '',
            'banners'       => isset($meta['banners']) ? $meta['banners'] : array(),
            'icons'         => isset($meta['icons']) ? $meta['icons'] : array(),
        );
        return $info;
    }
}
