<?php
if ( ! defined('ABSPATH') ) exit;

function swpl_get_slug() {
    $slug = get_option( SWPL_SLUG_OPTION, SWPL_DEFAULT_SLUG );
    $slug = trim( sanitize_title( $slug ), '/' );
    return $slug ? $slug : SWPL_DEFAULT_SLUG;
}

function swpl_login_url() {
    return home_url( '/' . swpl_get_slug() . '/' );
}

function swpl_flush_rules() {
    swpl_remove_rules();
    $slug = swpl_get_slug();
    add_rewrite_rule("^{$slug}/?$", 'index.php?swpl_login=1', 'top');
    add_rewrite_tag('%swpl_login%', '1');
    flush_rewrite_rules();
}

function swpl_remove_rules() {
    // WordPress kendi içinde rewrite’ı yeniden oluşturacak; ekstra temizlik gerekmiyor.
}


/**
 * Sistemsel Tanıtım Bloğu
 */
function swpl_render_sistemsel_block() {
    $logo = 'https://plugin.sistemsel.com/sistemsel/logo.png';
    $text = 'Dijital dünyada fark yaratmanın tam zamanı! Web tasarımı, e-ticaret, sosyal medya ve Google reklam hizmetlerimizle markanızı büyütüyoruz. Hedeflerinize en uygun stratejiyi birlikte belirleyelim.';
    $tel_raw = '0212 871 25 80';
    $tel_href = '+902128712580';
    $email = 'info@sistemsel.com';
    $web  = 'https://www.sistemsel.com';

    echo '<hr style="margin:30px 0;">';
    echo '<div class="swpl-sistemsel" style="display:flex;align-items:flex-start;gap:16px;font-family:Arial, sans-serif;">';
        echo '<div style="flex:0 0 auto;"><img src="'.esc_url($logo).'" alt="Sistemsel Medya" style="height:50px"></div>';
        echo '<div style="line-height:1.5;">';
            echo '<strong style="font-size:15px;display:block;margin-bottom:4px;">Sistemsel Medya</strong>';
            echo '<div style="margin-bottom:8px;max-width:640px;">'.esc_html($text).'</div>';
            echo '<div style="font-size:13px;color:#444;">';
                echo '🌐 <a href="'.esc_url($web).'" target="_blank" rel="noopener" style="color:#2271b1;text-decoration:none;">'.parse_url($web, PHP_URL_HOST).'</a> &nbsp;·&nbsp; ';
                echo '📞 <a href="tel:'.esc_attr($tel_href).'" style="color:#2271b1;text-decoration:none;">'.esc_html($tel_raw).'</a> &nbsp;·&nbsp; ';
                echo '✉️ <a href="mailto:'.antispambot($email).'" style="color:#2271b1;text-decoration:none;">'.antispambot($email).'</a>';
            echo '</div>';
        echo '</div>';
    echo '</div>';
}
