<?php
/*
Plugin Name: Sistemsel WP Login Gizleme
Plugin URI: https://plugin.sistemsel.com/updates/sistemsel-wp-login/
Description: WordPress giriş URL’sini kendi belirlediğiniz kısa yola taşıyın. Doğrudan wp-login.php ve yetkisiz wp-admin istekleri anasayfaya yönlendirilir. Dış bağımlılık yok, self-hosted güncelleme destekli.
Version: 1.0.11
Author: Sistemsel Medya
Author URI: https://sistemsel.com
License: GPLv2+
Requires at least: 5.0
Tested up to: 6.7
Requires PHP: 7.2
Text Domain: sistemsel-wp-login
Domain Path: /languages
*/

if ( ! defined('ABSPATH') ) exit;

define( 'SWPL_VERSION',        '1.0.11' );
define( 'SWPL_SLUG_OPTION',    'swpl_login_slug' );
define( 'SWPL_DEFAULT_SLUG',   'giris' );
define( 'SWPL_FILE',           __FILE__ );
define( 'SWPL_BASENAME',       plugin_basename(__FILE__) );
define( 'SWPL_DIR',            plugin_dir_path(__FILE__) );
define( 'SWPL_URL',            plugin_dir_url(__FILE__) );
define( 'SWPL_UPDATE_JSON',    'https://plugin.sistemsel.com/updates/sistemsel-wp-admin/metadata.json' );

require_once SWPL_DIR . 'includes/helpers.php';
require_once SWPL_DIR . 'includes/class-updater.php';

// Aktivasyon: varsayılan slug ve rewrite
register_activation_hook( SWPL_FILE, function() {
    if ( ! get_option(SWPL_SLUG_OPTION) ) {
        update_option(SWPL_SLUG_OPTION, SWPL_DEFAULT_SLUG);
    }
    swpl_flush_rules();
});

// Deaktivasyon: rewrite temizle
register_deactivation_hook( SWPL_FILE, function() {
    swpl_remove_rules();
    flush_rewrite_rules();
});

// Çakışan popüler eklentilerle uyarı
add_action('admin_init', function () {
    if ( ! function_exists('is_plugin_active') ) {
        include_once ABSPATH . 'wp-admin/includes/plugin.php';
    }
    $conflicts = array(
        'rename-wp-login/rename-wp-login.php',
        'wps-hide-login/wps-hide-login.php',
    );
    foreach ( $conflicts as $plugin ) {
        if ( function_exists('is_plugin_active') && is_plugin_active($plugin) ) {
            add_action('admin_notices', function() use ($plugin){
                echo '<div class="notice notice-error"><p><strong>Sistemsel WP Login Gizleme:</strong> Benzer bir eklenti aktif: <code>' . esc_html($plugin) . '</code>. Lütfen çakışmayı önlemek için devre dışı bırakın.</p></div>';
            });
            return;
        }
    }
});

// Rewrite ve router
add_action('init', function () {
    $slug = swpl_get_slug();
    add_rewrite_rule("^{$slug}/?$", 'index.php?swpl_login=1', 'top');
    add_rewrite_tag('%swpl_login%', '1');
}, 1);

// rewrite_rules_array filtresi: Eski slug'lardan kalan tüm kuralları temizle ve yalnızca aktif slug'ı ekle
function swpl_filter_rewrite_rules( $rules ) {
    if ( ! is_array( $rules ) ) return $rules;

    // 1) Bu eklentinin oluşturduğu önceki tüm kuralları sil
    foreach ( $rules as $pattern => $query ) {
        if ( is_string( $query ) && strpos( $query, 'swpl_login=1' ) !== false ) {
            unset( $rules[ $pattern ] );
        }
    }

    // 2) Aktif slug için kuralı en üste ekle
    $slug = swpl_get_slug();
    $new  = array();
    $new[ "^{$slug}/?$" ] = 'index.php?swpl_login=1';

    // En öne ekle
    return $new + $rules;
}
add_filter( 'rewrite_rules_array', 'swpl_filter_rewrite_rules', 20, 1 );



// Doğrudan wp-login.php isteklerini özel slug'a (query string korunarak) yönlendir
add_action('login_init', function () {
    $uri = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '';
    if ( stripos($uri, 'wp-login.php') !== false && ! isset($_GET['swpl_bypass']) ) {
        $target = swpl_login_url();
        if ( ! empty($_GET) ) {
            $target = add_query_arg( array_map('wp_unslash', $_GET), $target );
        }
        wp_safe_redirect( $target );
        exit;
    }
});


add_action('template_redirect', function () {
    if ( get_query_var('swpl_login') ) {
        require_once ABSPATH . 'wp-login.php';
        exit;
    }
}, 0);

// wp-admin koruması: giriş yapmamış kullanıcıyı anasayfaya yönlendir
add_action('init', function () {
    if ( is_admin() && ! is_user_logged_in() && ! defined('DOING_AJAX') ) {
        wp_safe_redirect( home_url('/') );
        exit;
    }
}, 0);

// URL filtreleri: wp_login_url vb. fonksiyonlar özel slug’ı döndürsün (sorgu parametrelerini koru)
add_filter('site_url', function($url, $path, $scheme, $blog_id){
    if ( false !== strpos($url, 'wp-login.php') ) {
        $parts = wp_parse_url($url);
        $target = swpl_login_url();
        if ( ! empty($parts['query']) ) {
            parse_str($parts['query'], $q);
            $target = add_query_arg( $q, $target );
        }
        return $target;
    }
    return $url;
}, 10, 4);

// Ayar sayfası
add_action('admin_menu', function () {
    add_options_page(
        'Sistemsel WP Login Gizleme',
        'WP Login Gizleme',
        'manage_options',
        'sistemsel-wp-login',
        'swpl_settings_page'
    );
});

function swpl_settings_page() {
    if ( ! current_user_can('manage_options') ) return;

    if ( isset($_POST['swpl_save']) && check_admin_referer('swpl_save_nonce') ) {
        $slug = sanitize_title( wp_unslash( $_POST['swpl_login_slug'] ?? '' ) );
        if ( empty($slug) ) $slug = SWPL_DEFAULT_SLUG;
        update_option(SWPL_SLUG_OPTION, $slug);
        swpl_flush_rules();
        echo '<div class="updated"><p>Ayarlar kaydedildi. Yeni giriş URL’niz: <code>' . esc_html( swpl_login_url() ) . '</code></p></div>';
    }

    $slug = esc_attr( swpl_get_slug() );
    echo '<div class="wrap"><h1>Sistemsel WP Login Gizleme</h1>';
    echo '<form method="post">';
    wp_nonce_field('swpl_save_nonce');
    echo '<table class="form-table"><tr><th scope="row">Giriş slug</th><td>';
    echo '<input type="text" name="swpl_login_slug" value="' . $slug . '" class="regular-text" />';
    echo '<p class="description">Örn: <code>giris</code> → ' . esc_html( home_url("/{$slug}/") ) . '</p>';
    echo '</td></tr></table>';
    submit_button('Kaydet', 'primary', 'swpl_save');
    echo '</form>';

    if ( function_exists('swpl_render_sistemsel_block') ) { swpl_render_sistemsel_block(); }
    echo '</div>'; // .wrap
}
// Self-hosted updater’ı başlat
add_action('admin_init', function () {
    new SWPL_Updater( SWPL_BASENAME, SWPL_UPDATE_JSON, SWPL_VERSION );
});
